cd "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files"
use "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files\temp_prom.dta", clear

	
gen wage_desc= wage_inc_real_mean/10
gen wage_p_desc= wage_inc_real_p_mean/10
gen wage_desc_lag=wage_inc_real_lag/10
gen wage_p_desc_lag= wage_inc_real_p_lag/10

gen wage_pos=wage_desc>wage_p_desc if wage_desc!=. & wage_p_desc!=.
gen wage_pos_lag=wage_desc_lag>wage_p_desc_lag if wage_desc_lag!=. & wage_p_desc_lag!=.

*runt the tests for the descriptive statistics tables
log using t_test, replace
foreach var of varlist  wage_inc_real_share_lag  ppshare_rel_co age_diff  wage_pos_lag mar_length_0 ///
 sec_mar_n4 child_0_6_d_0 child_0_18_d_0 age_0   age_mar_n4  wage_desc_lag ter_ed_0 agep_p_0 wage_p_desc_lag  ter_ed_p_n4 ///
 inc_res iq leader  {
ttest `var'  if woman==1 & rem_mar5_n4==1 & (main==1), by(treat)
ttest `var'  if woman==0 & rem_mar5_n4==1 & (main==1), by(treat)
}
foreach var of varlist  wage_inc_real_share_lag  ppshare_rel_co age_diff  wage_pos_lag mar_length_0 ///
 sec_mar_n4 child_0_6_d_0 child_0_18_d_0 age_0   age_mar_n4  wage_desc_lag ter_ed agep_p_0 wage_p_desc_lag  ter_ed_p ///
 inc_res iq leader  {
ttest `var'  if woman==1 & rem_mar5_n4==1 & (close==1), by(treat)
ttest `var'  if woman==0 & rem_mar5_n4==1 & (close==1), by(treat)
}
log close


*defines the groups for the descriptive statistics table
gen group_t1= 1 if treat ==1  & woman==1 & rem_mar5_n4==1 & (main==1)
replace group_t1= 2  if treat ==0  & woman==1 & rem_mar5_n4==1 & (main==1)
replace group_t1= 3  if treat ==1  & woman==0 & rem_mar5_n4==1 & (main==1)
replace group_t1= 4  if treat ==0 & woman==0 & rem_mar5_n4==1 & (main==1)
	
gen group_t2= 1 if treat ==1  & woman==1 & rem_mar5_n4==1 & (close==1)
replace group_t2= 2  if treat ==0  & woman==1 & rem_mar5_n4==1 & (close==1)
replace group_t2= 3  if treat ==1  & woman==0 & rem_mar5_n4==1 & (close==1)
replace group_t2= 4  if treat ==0 & woman==0 & rem_mar5_n4==1 & (close==1)
	
*Mkes a table with the data for the descriptive statics tables
*log using desc_tab, replace
gen loop=0
	
foreach group in  group_t1 group_t2  {
	drop loop
	gen loop=0
	matrix m_`group' =J(19,4,.)
	foreach var of varlist  wage_inc_real_share_lag  ppshare_rel_co age_diff  wage_pos_lag mar_length_0 ///
	sec_mar_n4 child_0_6_d_0 child_0_18_d_0 age_0   age_mar_n4  wage_desc_lag ter_ed_0 agep_p_0 wage_p_desc_lag  ter_ed_p_n4 ///
	inc_res iq leader  { 
		replace loop=loop+1
		scalar row=loop

		forvalues n=1/4{
			scalar col=`n' 
			sum `var' if `group'==`n' 
			matrix m_`group'[row,`n']=r(mean)
	
		}
	}
}
foreach group in  group_t1 group_t6 group_t2 group_t3  group_t4 group_t5{
	matrix list m_`group'
}

log close
*mle

*creates figure ten
hist ppshare_rel_co if (main==1) & woman==1, bin(20) scheme(s1mono)  title(Women) xtitle(Share of Parental Leave) freq ylabel(, angle(horizontal)) 
graph save parental_woman.gph, replace
	 
hist ppshare_rel_co if (main==1) & woman==0,  bin(20) scheme(s1mono) title(Men) xtitle(Share of Parental Leave) freq ylabel(, angle(horizontal)) 
graph save parental_man.gph, replace
	
graph combine  parental_woman.gph parental_man.gph, iscale(1.2) ycommon xcommon scheme(s1mono) xsize(20) ysize(8)
graph save parental.gph, replace
	
hist age_diff if (main==1) & woman==1  & abs(age_diff)<16, freq ///
scheme(s1mono)  title(Women) xtitle(Age Difference) discrete width(1)  xlabel(-15(5)15) ylabel(, angle(horizontal)) 
graph save age_diff_woman.gph, replace
	 
hist age_diff if (main==1) & woman==0  & abs(age_diff)<=15, freq ///
scheme(s1mono) title(Men) xtitle(Age Difference) discrete width(1) xlabel(-15(5)15) ylabel(, angle(horizontal)) 
graph save age_diff_man.gph, replace
	
graph combine  age_diff_woman.gph age_diff_man.gph, iscale(1.2) ycommon  scheme(s1mono) xsize(20) ysize(8)  
	graph save age_diff.gph, replace
					
graph combine   age_diff_woman.gph age_diff_man.gph  parental_woman.gph parental_man.gph, iscale(.8) scheme(s1mono) xsize(20) ysize(14) col(2)
graph save fig_10.gph, replace
		
	
gen wage_change_h=wage_inc_real_ch/10 if wage_inc_real_ch>-2000
hist wage_change_h if (main==1) & woman==1 & treat==1, width(25) start(-200) scheme(s1mono)  title(Women) xtitle(Change in Wage)  freq ylabel(, angle(horizontal)) 
graph save wage_ch_woman.gph, replace
	  		
hist wage_change_h if (main==1) & woman==0 &  treat==1,  width(25) start(-200) scheme(s1mono) title(Men) xtitle(Change in Wage) freq ylabel(, angle(horizontal)) 
graph save wage_ch_man.gph, replace
graph combine  wage_ch_woman.gph wage_ch_man.gph, iscale(1.2)  scheme(s1mono) xsize(20) ysize(8)
graph save fig_2.gph, replace
	
*Descriptive statistics on remarriage for Figure 9
forvalues n= 1/6{
	gen new_mar_`n' = mar_`n' if rem_mar_r1==0 & mar_0==1
}

forvalues n= 1/6{
	local num=`n'+1
	replace new_mar_`n' = mar_`num' if rem_mar_r1==1 & rem_mar_r2==0 & mar_0==1
}
forvalues n= 1/6{
	local num=`n'+2
	replace new_mar_`n' = mar_`num' if rem_mar_r2==1 & rem_mar_r3==0 & mar_0==1
}

forvalues n= 1/8{
	gen mar_p_`n' = civil_p_`n'=="G" | civil_p_`n'=="G "  if civil_p_`n'!=""
}
bysort woman treat: sum new_mar* if main==1
